// -----------------------------------------------------------------------------------------

library Blank;         // Rename this, it becomes the name of the DLL

uses
  Windows,
  Unit1 in 'Unit1.pas' {Form1};

{$E dll}               // To tell the compiler to make a DLL not an EXE
{$R *.res}

// -----------------------------------------------------------------------------------------
(*
 *  Blank Plugin skeleton -- Version 1.2 -- By Bob
 *
 *  Updated 16/02/2005
 *    o  Added check if PEiD is always on top, only hide PEiD if set on top..
 *)
// -----------------------------------------------------------------------------------------

Const
  // The name that shows-up in PEiD's list of plugins
  Plugin_Name = 'Un-named Plugin by Bob';

// -----------------------------------------------------------------------------------------

Type
  DLL_RET_MSG = Record
    szMsgText : PChar;
    szMsgHead : PChar;
    dRetVal   : DWORD;
    dRetExVal : DWORD;
    dFlags    : DWORD;
  End;

// -----------------------------------------------------------------------------------------
// The main procedure..  If you don't want a form, remove it here and replace
//  with your code (and remove unit1 above)

function RunPlugin(hMainDlg: HWND; szFname: PChar) : String;
begin

    // pass filename to plugin
    // pass hwnd of PEiD, or PE-Tools, if useful to you

    Target_Filename := szFname;
    Caller_Handle := hMainDlg;


    // Put your code here, and in Form1.create as usual


    Form1 := TForm1.Create(Nil);
    Try
      Form1.ShowModal;
    Finally
      Form1.Free;
    End;

    // displayed in PEiD message box, where it would say packer name
    result := 'Done :)';

end;

// -----------------------------------------------------------------------------------------

function DoMyJob(hMainDlg: HWND; szFname: PChar; lpReserved: DWORD; DRM: DLL_RET_MSG):DWORD; cdecl;
const
  BM_GETCHECK = $00F0;    // message code for get checkbox..
  cbOnTop = $03F8;        // Control ID for PEiD's Always On Top checkbox..
  ebOutput = $03E9;       // Control ID of PEiD's output edit control..
var
  S : String;
  PEiD_OnTop : Boolean;
begin
  Result:=1;

  // Update:  Get state of Always On Top Checkbox from PEiD's main window..
  PEiD_OnTop := (SendDlgItemMessage(hMainDlg,cbOnTop,BM_GETCHECK,0,0) = BST_CHECKED);

  // Guard against errors
  Try

    // Now we know if we need to hide PEiD..
    IF PEiD_OnTop THEN
      // Hide PEiD, if it's set to be always on top
      ShowWindow(hMainDlg,SW_HIDE);

    // call main routine, with filename.  S is a string returned for status etc
    S := RunPlugin(hMainDlg,szFname);

    IF S <> '' THEN
      // write string into PEiD message box :)
      SetDlgItemText(hMainDlg,ebOutput,PChar(S));

  // in case of error, PEiD will be unhidden
  Finally
    IF PEiD_OnTop THEN
      // show PEiD again, if hidden
      ShowWindow(hMainDlg,SW_SHOW);
  End;
end;

// -----------------------------------------------------------------------------------------

function StartPTPlugin(hDlg:HWND):DWord;stdcall;
Const
  ebOutput = $9900;  // Control ID of PE-Tools' output
var
  S : String;
begin
 S := RunPlugin(hDlg,'');                  // Call main procedure, from PE-Tools
                                           // Note PE-Tools doesn't give you a filename,
                                           // so a open dialog or something must be used to get a file.
 IF S <> '' THEN
   SetDlgItemText(hDlg,ebOutput,PChar(S)); // Write to PE-Tools message box :)

 Result:=0;
end;

// -----------------------------------------------------------------------------------------

function LoadDll:PChar;cdecl;
begin
  result := Plugin_Name;                   // Called by PEiD to get the plugins name
end;

// -----------------------------------------------------------------------------------------

function GetPTPluginName:PChar;stdcall;
begin
  Result := Plugin_Name;                   // same, but for PE-Tools
end;

// -----------------------------------------------------------------------------------------

exports
    LoadDll,                // Called by PEiD to get plugins name
    DoMyJob,                // Called by PEiD to do plugins work

    GetPTPluginName,        // Called by PE-Tools to get plugins name
    StartPTPlugin;          // called by PE-Tools to do plugins work

// -----------------------------------------------------------------------------------------

begin
end.

// -----------------------------------------------------------------------------------------

